//Program to find out power system voltage at the end of the iteration by gauss siedal method//
//This program requires user input. A sample problem with user input and output is available in the result file//
//Question of example problem is available in file "GausssSeidalQuestionFile.jpg" and result is available in the file "GaussSeidalOutputFile.jpg"
//Scilab Version 5.5.2 ; OS:Windows
clc;
clear;
linedata=input('enter the linedata in the order of starting bus,ending bus,series resistance,series inductance and shunt suspectance in matrix form:')
sb=linedata(:,1)  //Starting bus number of all the lines stored in variable sb //
eb=linedata(:,2)  //Ending bus number of all the lines stored in variable eb //
lz=linedata(:,3)+linedata(:,4)*%i   //lineimpedance=R+jX //
sa=-linedata(:,5)*%i  //shunt admittance=-jB //
nb=max(max(sb,eb));  //number of buses calculation //
y=zeros(nb,nb);
for i=1:length(sb)   // starting of admittance bus matrix calculation part //
    m=sb(i);
    n=eb(i);
    y(m,m)=y(m,m)+1/lz(i)+(sa(i)/2);
    y(n,n)=y(n,n)+1/lz(i)+(sa(i)/2);
    y(m,n)=-1/lz(i);
    y(n,m)=y(m,n);
end                 // end of admittance bus matrix calculation part  //
disp(y,'y bus admittance is:');
busdata=input('enter busdata in the order type (1.slack,2.pv,3.pq),PG,QG,PL,QL,vmag,del,Qmin and Qmax:')
typ=busdata(:,1) // type of all buses in the power system is stored in typ variable //
qmin=busdata(:,8) // minmum limit of Q for all the  buses is stored in the variable qmin//
qmax=busdata(:,9)  // maximum limit of Q for all the buses is stored in the variable qmax//
p=busdata(:,2)-busdata(:,4) // real power of all the buses are calculated and is stored in the variable p //
q=busdata(:,3)-busdata(:,5)  // reactive power of all the buss are calculated and is stored in the variable q //
v=busdata(:,6).*(cosd(busdata(:,7))+%i*sind(busdata(:,7))); 
alpha=input('enter the value of accelaration factor:');
iter=1;
err=1;
vn(1)=v(1);
vold=v(1);
while abs(err)>5*10^(-5) //  starting of calculation part of bus voltage for first iteration //
    for i=2:nb
        sumyv=0;
        for j=1:nb
            sumyv=sumyv+y(i,j)*v(j);
        end
        if typ(i)==2
            q(i)=-imag(conj(v(i)*sumyv));
            if q(i)<qmin(i) |q(n)>qmax(i) 
                vn(i)=(1/y(i,i))*(((p(i)-%i*q(i))/(conj(v(i))))-(sumyv-y(i,i)*v(i)));
                vold(i)=v(i);
                v(i)=vn(i);
                typ(i)=3
            if q(i)<qmin(i) 
                q(i)=qmin(i);
            else
                q(i)=qmax(i);
            end
        else
            vn(i)=(1/y(i,i))*(((p(i)-%i*q(i))/(conj(v(i))))-(sumyv-y(i,i)*v(i)));
            ang=atan(imag(vn(i)),real(vn(i)));
            vn(i)=abs(v(i))*(cos(ang)+%i*sin(ang));
            vold(i)=v(i);
            v(i)=vn(i);  
        end
        elseif typ(i)==3
            vn(i)=(1/y(i,i))*(((p(i)-%i*q(i))/(conj(v(i))))-(sumyv-y(i,i)*v(i)));  
            vold(i)=v(i);
            v(i)=vn(i);
        end
        end
err=max(abs(abs(v)-abs(vold)));

iter=iter+1;
for i=2:nb
    if err>5*10^(-6) &typ(i)==3
    v(i)=vold(i)+alpha*(v(i)-vold(i));
    end
end
end
printf('the GS load flow converged in %d iterations \n',iter-1);
nn=1:nb;
res=[nn' abs(v) (atan(imag(v),real(v)))*(180/%pi)]
disp(res,'the final voltages are in the order of bus no,v mag,v angle:');

//SAMPLE INPUT and OUTPUT
//enter the linedata in the order of starting bus,ending bus,series resistance,series inductance and shunt suspectance in matrix form:[1 2 0 0.4 0;2 3 0 0.2 0;1 3 0 0.3 0]
 
 //y bus admittance is:   
 
//  - 5.8333333i    2.5i    3.3333333i  
//    2.5i        - 7.5i    5.i         
//    3.3333333i    5.i   - 8.3333333i  
//enter busdata in the order type (1.slack,2.pv,3.pq),PG,QG,PL,QL,vmag,del,Qmin and Qmax:[1 0 0 0 0 1.05 0 0 0;2 0.3 0 0 0 1.02 0 -0.1 1;3 0 0 0.4 0.2 1 0 0 0]
//enter the value of accelaration factor:1
//the GS load flow converged in 5 iterations 
 
 //the final voltages are in the order of bus no,v mag,v angle:   
 
//    1.    1.05         0.         
//    2.    1.02         0.7840633  
//    3.    1.0070672  - 2.1827934  






   
